SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

------------------------------------------------------------------------------------------------------------------------------------------
-- Add new tables CaseActionHistory and CaseActionHistoryDetail to keep Case Action History for each importation and Callback assignment
------------------------------------------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id('[CaseActionHistory]') AND OBJECTPROPERTY(id, 'IsUserTable') = 1)
BEGIN  
  CREATE TABLE CaseActionHistory
  (
		[ActionId]			int identity(1,1) NOT NULL,
		[ActionType]		nvarchar(255) NOT NULL,
		[DataSourceName]	nvarchar(255) NOT NULL,
		[CaseCount]			bigint NOT NULL,
		[FilterDefinition]	nvarchar(max) NOT NULL,
		[Description]		nvarchar(max) NOT NULL,
		[ModifiedBy]		int NOT NULL,
		[Modified]			datetime NOT NULL
 CONSTRAINT [PK_CaseActionHistory] PRIMARY KEY CLUSTERED 
(
	[ActionId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id('[CaseActionHistoryDetail]') AND OBJECTPROPERTY(id, 'IsUserTable') = 1)
BEGIN  
  CREATE TABLE CaseActionHistoryDetail
  (
		[ActionDetailId]	int identity(1,1) NOT NULL,
		[ActionId]			int NOT NULL,
		[ActionDetailType]	nvarchar(255) NOT NULL,
		[CaseId]			varchar(10) NOT NULL,
		[ModifiedBy]		int NOT NULL,
		[Modified]			datetime NOT NULL
	CONSTRAINT [PK_CaseActionHistoryDetail] PRIMARY KEY CLUSTERED 
    (
	  [ActionDetailId] ASC
    )WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
  ) ON [PRIMARY]

  ALTER TABLE CaseActionHistoryDetail
	ADD CONSTRAINT FK_CaseActionHistoryDetail_CaseActionHistory FOREIGN KEY (ActionId)
	REFERENCES CaseActionHistory(ActionId)

  CREATE NONCLUSTERED INDEX [IX_CaseActionHistoryDetail] ON [dbo].CaseActionHistoryDetail
  (
	[ActionId] ASC
  )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
END
GO

SET IDENTITY_INSERT CaseActionHistory ON
GO

IF EXISTS (SELECT * FROM ImportHistory)
BEGIN
    -- Use ImportHistory to import into CaseActionHistory
    INSERT INTO CaseActionHistory (ActionId, ActionType, DataSourceName, CaseCount, FilterDefinition, [Description], Modified, ModifiedBy)
    SELECT IHNumber,
		   CASE WHEN IHFileName is null THEN 'CBAssignment' ELSE 'Import' END,
		   ISNULL(IHFileName,''),
		   CASE WHEN ISNULL(IHEndNumber,0) = 0 OR  ISNULL(IHStartNumber,0) = 0 THEN 0 ELSE ISNULL(IHEndNumber,0) - ISNULL(IHStartNumber,0) + 1 END,
		   '',
		   'Migration',
		   IHDateTime,
		   modifiedBy
	  FROM ImportHistory
	  ORDER BY IHNumber

    -- Insert respondents from RespondentModifLog into CaseActionHistoryDetail
    INSERT INTO CaseActionHistoryDetail (ActionId, ActionDetailType, CaseId, Modified, ModifiedBy)
    SELECT RMF.IHNumber,
		   CASE WHEN MAX(IH.IHFileName) is null THEN 'CBAssigned' ELSE 'ImportMigration' END,
		   RMF.Respondent,
		   MAX(RMF.modified),
		   MAX(RMF.modifiedBy)
	  FROM RespondentModifLog RMF
	  JOIN ImportHistory IH			on  IH.IHNumber = RMF.IHNumber
	  GROUP BY RMF.IHNumber, RMF.Respondent
	  ORDER BY RMF.IHNumber, RMF.Respondent

END 

SET IDENTITY_INSERT CaseActionHistory OFF
GO

sp_RENAME 'RespondentModifLog.IHNumber', 'ActionId' , 'COLUMN'
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_InsertImportationWave]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[Sp_InsertImportationWave]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_CancelImportationWave]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[Sp_CancelImportationWave]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_resetprojectdata]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[Sp_resetprojectdata]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_deleterespondent]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[Sp_deleterespondent]
GO
